function achilles_zelva(koeficient,naskok,rychlost_zelvy);

% koeficient rika kolikrat je Achilles rychlejsi nez zelva
% naskok zelvy pred Achillem v metrech
% pokud je parametr zadan, budou uvedeny casy pro zadanou rychlost zelvy 

clc;
disp('               Dohoni Achilles zelvu ?                 ');
disp('-------------------------------------------------------');

if exist('koeficient')==1 & exist('naskok')==1
  disp(sprintf(' Achilles je  %f  krat rychlejsi nez zelva.',koeficient));
  disp(sprintf(' Zelva ma naskok  %f metru.',naskok));
  if exist('rychlost_zelvy')==1
    disp(sprintf(' Rychlost zelvy je  %f m/s.',rychlost_zelvy));
  end;
else
  fprintf(' Zadej kolikrat je Achilles rychlejsi ... ');
  koeficient        =input(' ');
  fprintf(' Zadej naskok zelvy v metrech         ... ');
  naskok            =input(' ');
  fprintf(' Zadej rychlost zelvy v m/s           ... ');
  rychlost_zelvy    =input(' ');
end;

A=0;
Z=naskok;
T=0;
mez=naskok+naskok/koeficient/(1-1/koeficient);
epsilon=0.05*mez;
if exist('rychlost_zelvy')==1
 zobraz_cas=1;
else
 zobraz_cas=0;
end;

figure(1);
clf;
set(gca,'XLim',[-epsilon,mez+epsilon]);
set(gca,'YLim',[0,3]);
hold on;

i=1;
while mez-Z(i)>mez*.05 | i<10
 A(i+1)=Z(i);
 Z(i+1)=Z(i)+(A(i+1)-A(i))/koeficient;
 if zobraz_cas
   T(i+1)=T(i)+(A(i+1)-A(i))/(koeficient*rychlost_zelvy);
   if i>1
     h=text(mez/10,2.7,popis);
     set(h,'Color',[1,1,1]);
   end;
   popis=strcat('Aktualni cas = ',num2str(T(i),15),' s ');
   h=text(mez/10,2.7,popis);
   set(h,'Color',[0,0,0]);
 end;
 plot(A(i),1,'r+-');
 plot(Z(i),2,'b+');
 pause;
 plot(A,ones(size(A)),'b-');
 plot(Z,2*ones(size(Z)),'r-');
 i=i+1;
end;

if zobraz_cas
 disp(' ');
 disp(sprintf(' Achilles dohoni zelvu v case T = %f.',mez/koeficient/rychlost_zelvy));
end;
