function achilles_zelva_2(koeficient,naskok,rychlost_zelvy);

% koeficient rika kolikrat je Achilles rychlejsi nez zelva
% naskok zelvy pred Achillem v metrech
% pokud je parametr zadan, budou uvedeny casy pro zadanou rychlost zelvy 

clc;
disp('               Achilles zelvu predhoni                 ');
disp('-------------------------------------------------------');

if exist('koeficient')==1 & exist('naskok')==1 & exist('rychlost_zelvy')==1
  disp(sprintf(' Achilles je  %f  krat rychlejsi nez zelva.',koeficient));
  disp(sprintf(' Zelva ma naskok  %f metru.',naskok));
  disp(sprintf(' Rychlost zelvy je  %f m/s.',rychlost_zelvy));
else
  fprintf(' Zadej kolikrat je Achilles rychlejsi ... ');
  koeficient        =input(' ');
  fprintf(' Zadej naskok zelvy v metrech         ... ');
  naskok            =input(' ');
  fprintf(' Zadej rychlost zelvy v m/s           ... ');
  rychlost_zelvy    =input(' ');
end;

A=0;
Z=naskok;
mez=naskok+naskok/koeficient/(1-1/koeficient);
epsilon=0.05*mez;
cas=mez/koeficient/rychlost_zelvy;
krok=cas/10;

figure(1);
clf;
set(gca,'XLim',[-epsilon,2*mez+epsilon]);
set(gca,'YLim',[0,3]);
hold on;

i=1;
for t=0:krok:2*cas
  A(i)=rychlost_zelvy*koeficient*t;
  Z(i)=naskok+rychlost_zelvy*t;
  if i>1
     h=text(mez/10,2.7,popis);
     set(h,'Color',[1,1,1]);
  end;
  popis=strcat('Aktualni cas = ',num2str(t),' s ');
  h=text(mez/10,2.7,popis);
  set(h,'Color',[0,0,0]);
  plot(A(i),1,'r+');
  plot(Z(i),2,'b+');
  plot(A,ones(size(A)),'b-');
  plot(Z,2*ones(size(Z)),'r-');
  pause;
  i=i+1;
end;
