function aproximace_funkce(funkce,a,b);

clc;
disp('              Aproximace spojite funkce                ');
disp('-------------------------------------------------------');

if exist('funkce')==1 & exist('a')==1 & exist('b')==1
  disp(sprintf(' Aproximuji funkci  f(x) = %s ',funkce));
  disp(sprintf(' a intervalu < %f , %f >.',a,b));
else
  fprintf(' Zadej predpis pro funkci  f(x) = ');
  funkce=input(' ','s');
  fprintf(' Zadej dolni mez intervalu    a = ');
  a=input(' ');
  fprintf(' Zadej horni mez intervalu    b = ');
  b=input(' '); 
end;

disp(' ');

krok=(b-a)/5;
krok_maly=krok/100;

x=a;
q=eval(funkce);


% pomocne vypocty pro vykresleni obrazku
 fce=funkce;
 delka=length(fce);
 i=0;
 while delka>i
  i=i+1;
  if fce(i)=='*' | fce(i)=='/' | fce(i)=='^'
   fce=strcat(fce(1:i-1),'.',fce(i:delka));
   i=i+1;
   delka=delka+1;
  end;
 end;

 x=a:krok_maly:b;
 y=eval(fce);
 x=a:krok:b;
 yy=eval(fce);
 [xxk,yyk,koeficienty]=polynom_L(x,yy,krok_maly,0);
 p=polyfit(x,yy,1); 
 yyyk=polyval(p,xxk);
 p=polyfit(x,yy,2); 
 yyyyk=polyval(p,xxk);
 p=polyfit(x,yy,3); 
 yyyyyk=polyval(p,xxk);
 body=fnplt(csape(x,yy,'variational'),'g');
 yyyyyyk=body(2,:); 
 ymin=min([y,yyk,yyyk,yyyyk,yyyyyk,yyyyyyk]);
 ymax=max([y,yyk,yyyk,yyyyk,yyyyyk,yyyyyyk]);
 dy=ymax-ymin;
 ymin=ymin-0.05*dy;
 ymax=ymax+0.05*dy;
 xmin=a-0.05*(b-a);
 xmax=b+0.05*(b-a);
 
% Spojita funkce
disp(' Graf spojite funkce ') 
x=a:krok_maly:b;
y=eval(fce);

figure(1);
clf;
hold on;
set(gca,'XLim',[xmin,xmax]);
set(gca,'YLim',[ymin,ymax]);
plot(x,y,'b-'); 
popis=sprintf('Puvodni spojita funkce                     ');
texty(1,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Diskretne zadana funkce
disp(' Konecny pocet bodu dane funkce ') 
     x=a:krok:b;
y=eval(fce);
xx=x;
yy=y;
plot(x,y,'ro'); 
popis=sprintf('Funkce zadana hodnotou v bodech           ');
texty(2,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Aproximace lomenou carou (linearni spline funkce)
disp(' Aproximace lomenou carou (linearni spline funkce)')
plot(xx,yy,'k-'); 
popis=sprintf('Lomena cara (linearni spline)             ');
texty(3,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Aproximace interpolacnim polynomem
disp(' Aproximace interpolacnim polynomem ')
[xxk,yyk,koeficienty]=polynom_L(xx,yy,krok_maly,0);
plot(xxk,yyk,'m-');
popis=sprintf('Interpolacni polynom                      ');
texty(4,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Aproximace kubickym splinem s prirozenymi podminkami
disp(' Aproximace prirozenym kubickym splinem ')
fnplt(csape(xx,yy,'variational'),'g',[a,b],0.5);
popis=sprintf('Prirozeny kubicky spline                  ');
texty(5,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Diskretni L2 aproximace linearni funkci
disp(' Diskretni L2 aproximace linearni funkci ')
p=polyfit(xx,yy,1); 
yyk=polyval(p,xxk);
plot(xxk,yyk,'r-');
popis=sprintf('Diskretni L2 aproximace - linearni        ');
texty(6,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Diskretni L2 aproximace kvadratickou funkci
disp(' Diskretni L2 aproximace kvadratickou funkci ')
p=polyfit(xx,yy,2); 
yyk=polyval(p,xxk);
plot(xxk,yyk,'b--');
popis=sprintf('Diskretni L2 aproximace - kvadraticka    ');
texty(7,:)=popis(1:40);
legend(texty,'Location','Best');

pause

% Diskretni L2 aproximace kubickou funkci
disp(' Diskretni L2 aproximace kubickou funkci ')
p=polyfit(xx,yy,3); 
yyk=polyval(p,xxk);
plot(xxk,yyk,'m--');
popis=sprintf('Diskretni L2 aproximace - kubicka          ');
texty(8,:)=popis(1:40);
legend(texty,'Location','Best');
