function [xk,fk,koeficienty]=polynom_L(x,f,deleni,presah);
%
% Vrati interpolovane hodnoty xk, fk pro deleni
% (presah v % uvede rozsireni intervalu <x1,xn>)
% koeficienty = vektor koeficientu polynomu

[x,indexy]=sort(x);
f=f(indexy);
n=max(size(x));
koef=zeros(n);

xk=x(1)-presah/100*(x(n)-x(1)):deleni:x(n)+presah/100*(x(n)-x(1));

for j=1:n
  pom=1;
  koreny=[x(1:j-1) x(j+1:n)];
  for m=1:n
    if m~=j
      pom=pom*(x(j)-x(m));
    end;
  end;  
  koef(j,:)=f(j)*poly(koreny)/pom;
end;
koeficienty=sum(koef,1);

for i=1:max(size(xk))
  fk(i)=0;
  for j=1:n
    fk(i)=fk(i)+koeficienty(j)*xk(i)^(n-j);
  end;
end
















