function derivace_podminenost(f, x0, h);
%
% Vykresli chybu numericky vypoctene prvni derivace 
% symbolicky zadane funkce f v bode x0 s kroky h 


clc;
pocet=length(h);
disp('----------------------------------------------------------------');
disp(sprintf(' Vykresli chybu pri numerickem vypoctu derivace funkce '));
disp(sprintf('  f(x)=%s v bode x0=%f s kroky ',f,x0));

for j=1:ceil(pocet/8)
  if j==1 
    kroky=sprintf('  h=[');
  else 
    kroky=sprintf('     ');
  end;
  for i=(j-1)*8+1:min([j*8,pocet])
   kroky=[kroky,sprintf('%g',h(i))];
   if i<pocet
     kroky=[kroky,','];
   else 
     kroky=[kroky,']'];
   end;
  end;
  disp(kroky); 
end;
disp('----------------------------------------------------------------');
disp(' ');
disp(' chvilku strpeni (pocitam) ');

figure(1);
clf;

for i=1:pocet
  [der_fce,D_P]=derivace_vypocet(f, x0, h(i));
  chyba_D_P(i)=der_fce-D_P;
end;
fmin=min(abs([chyba_D_P]));
fmax=max(abs([chyba_D_P]));
df=fmax-fmin;
fmin=fmin/10;
fmax=fmax*10;

loglog(h,abs(chyba_D_P),'m-');
axis([min(h)/10 max(h)*10 fmin fmax]); 

hold on;
zoom on;
loglog(h,abs(chyba_D_P),'r>');
texty(1,:)=sprintf('                                         ');
texty(2,:)=sprintf(' pomoci prave pomerne diference D_P      ');
legend(texty);



