function umv(action,categoryArg)
%
%   Vyukovy program pro predmet UVOD DO MATEMATICKYCH VYPOCTU 
%
%   Spusti se prikazem "umv" v prikazovem radku
%
%   Mozne argumenty jsou (staci jen cast nazvu)
%        ('1_prednaska'|...
%         '2_prednaska'|...
%         '3_prednaska'|... 
%         '4_prednaska'|... 
%         '5_prednaska'|... 
%         '6_prednaska'|... 
%         '7_prednaska'|... 
%         '8_prednaska'|... 
%         '9_prednaska'|... 
%         '10_prednaska'|... 
%         '11_prednaska'|... 
%         'pisemna_prace'),
%
%   UMV otevre UMV s uvedenym tematem.
%
%   Josef Danek

datum='2025-10-29';


pomocny_adresar='nastaveni';

if nargin<1,
   action = 'show';
   fSelectCategory = 0;
   fCmdLine = 1;
else
   action = lower(action);
end;

indent = '      ';


% add switch for show events
categoryNames = {'1_prednaska',...
                 '2_prednaska',...
                 '3_prednaska',...
                 '4_prednaska',...
                 '5_prednaska',...
                 '6_prednaska',...
                 '7_prednaska',...
                 '8_prednaska',...
                 '9_prednaska',...
                 '10_prednaska',...
                 '11_prednaska',...
                 'pisemna prace'};

if (nargin > 0)
   fCmdLine = 0;
   % strmatch will also match partial strings
   catMatch = strmatch(action, categoryNames);
   % should only match one of these
   % but take only the first anyway
   if ~isempty(catMatch)
      action = ['show' categoryNames{catMatch(1)}];
      fCmdLine = 1;  
   end
   fSelectCategory = (nargin==2);
end

chooseMsg = 'Vyber téma pro nabídku příkladů';
clickMsg = 'Dvakrát klikni pro zobrazení tohoto tématu';

figHandles = allchild(0);
figH=findobj(figHandles, 'flat', 'Name', 'Úvod do Matematických Výpočtů', ...
   'Tag', 'umv');                         

if strcmp('rundemo',action)
   if isempty(figH)
      LocalRunDemo(findobj(figH,  'Type', 'uicontrol', 'Tag', 'test'));
   end;
% ====================================
% Handle the SHOW events
elseif strmatch('show',action)
   
   if isempty(figH)
      umv initialize;
      figHandles = allchild(0);                 
      figH=findobj(figHandles, 'flat', 'Name', 'Úvod do Matematických Výpočtů', ...
         'Tag', 'umv');
      set(figH,'HandleVisibility','off');
   end;
   
   % raise the demo window if we're being invoked from the cmd line '
   if(fCmdLine)
     figure(figH);
   end
   
   % because HandleVis is off, don't use gcf, use figH '
   % get the global data
   param=get(figH,'UserData');
   
   % find ui controls
   % listboxes
   categoryListH = findobj(figH, ...
      'Type', 'uicontrol', 'Tag', 'CategoryListbox');
   index = get(categoryListH, 'UserData');
   demoListH = findobj(figH, 'Type','uicontrol','Tag','DemoListbox');
   aboutListH = findobj(figH,'Type','uicontrol','Tag','AboutListbox');
   aboutTopics = get(aboutListH, 'UserData');
   
   % buttons
   runBtn=findobj(figH, 'Type', 'uicontrol', 'Tag', 'test');
   pdfBtn=findobj(figH, 'Type', 'uicontrol', 'Tag', 'pdf');
   closeBtn=findobj(figH, 'Type', 'uicontrol', 'Tag','return');
   
   catValue = get(categoryListH, 'Value');
   
   theTopic = index.topic(catValue);
   theCategory = index.category(catValue);
   
   if fCmdLine
      clickType = 'none';
   else
      clickType = get(figH,'SelectionType');
   end
   
   % support direct calls to each topic area
   
   topicList = param.topicList;

   switch action
   case 'show1pr',
      theTopic = LocalGetTopic(topicList, '1. přednáška', 1);
      incremListUpdate = 0;
   case 'show2pr',
      theTopic = LocalGetTopic(topicList, '2. přednáška', 1);
      incremListUpdate = 0;
   case 'show3pr',
      theTopic = LocalGetTopic(topicList, '3. přednáška', 1);
      incremListUpdate = 0;
   case 'show4pr',
      theTopic = LocalGetTopic(topicList, '4. přednáška', 1);
      incremListUpdate = 0;
   case 'show5pr',
      theTopic = LocalGetTopic(topicList, '5. přednáška', 1);
      incremListUpdate = 0;
   case 'show6pr',
      theTopic = LocalGetTopic(topicList, '6. přednáška', 1);
      incremListUpdate = 0;
   case 'show7pr',
      theTopic = LocalGetTopic(topicList, '7 přednáška', 1);
      incremListUpdate = 0;
   case 'show8pr',
      theTopic = LocalGetTopic(topicList, '8. přednáška', 1);
      incremListUpdate = 0;
   case 'show9pr',
      theTopic = LocalGetTopic(topicList, '9. přednáška', 1);
      incremListUpdate = 0;
   case 'show10pr',
      theTopic = LocalGetTopic(topicList, '10. přednáška', 1);
      incremListUpdate = 0;
   case 'show11pr',
      theTopic = LocalGetTopic(topicList, '11. přednáška', 1);
      incremListUpdate = 0;
   case 'show12pr',
      theTopic = LocalGetTopic(topicList, 'písemná práce', 1);
      incremListUpdate = 0;
   otherwise
      incremListUpdate = 1;
   end
   
   if (~incremListUpdate)   % rewrite the list from scratch
      
      index.expanded = zeros(1,length(topicList));
      index.expanded(theTopic) = 1;
      action = 'showlist';
      
      if (fSelectCategory)  % use the second argument
         theCategory = LocalGetTopic(...
            LocalCellLower({param.pageList{theTopic}.Name}),...
            [indent lower(categoryArg)],...
            0);
         newValue = theCategory+theTopic;
      else
         newValue = theTopic;
         theCategory = 0;
      end
      
      
      theCategoryList = {}; % initialize
      nTopics = length(param.topicList);
      index.topic = [];
      index.category = [];
      
      for iTopic = 1:nTopics,
         if (index.expanded(iTopic))
            prefix = '-';
         else
            prefix = '+';
         end
         theCategoryList = cat(2, theCategoryList, ...
            {[prefix param.topicList{iTopic}]});
         index.topic = cat(2, index.topic, [iTopic]);
         index.category = cat(2, index.category, [0]);
         if (index.expanded(iTopic)),
            nCategories = length({param.pageList{iTopic}.Name});
            theCategoryList = cat(2, theCategoryList, ...
               {param.pageList{iTopic}.Name});
            index.topic = cat(2, index.topic, iTopic*ones(1,nCategories));
            index.category = cat(2, index.category, [1:nCategories]);
         end % if (index.expanded(iTopic)),
      end % for iTopic = 1:nTopics,

      set(categoryListH, 'String', theCategoryList);
      set(categoryListH, 'Value', newValue);
      set(categoryListH, 'ListboxTop', newValue);
      set(categoryListH, 'UserData', index);
   end

   switch action
   case 'showlist',
      if (theCategory == 0) % this is a topic heading
         % RECOMPUTE CATEGORY LIST
         % recompute the list to be displayed in the category listbox
         % compute indices (Topic, Category) for each 'value' of the
         % category list

         if (strcmp(clickType,'open'))
            index.expanded(theTopic) = not(index.expanded(theTopic));
            theCategoryList = get(categoryListH, 'String');

            currentLength = length(theCategoryList);
            insertPt = 1;
            while index.topic(insertPt) ~= theTopic
               insertPt = insertPt + 1;
            end
            if (index.expanded(theTopic))
               prefix = '-';
            else
               prefix = '+';
            end
            theCategoryList(insertPt) = ...
               {[prefix param.topicList{theTopic}]};
            oldListboxTop = get(categoryListH,'ListboxTop');
            if index.expanded(theTopic)
               nCategories =length({param.pageList{theTopic}.Name});
               index.topic = LocalSplice(insertPt,...
                  theTopic*ones(1,nCategories), index.topic);
               index.category = LocalSplice(insertPt,...
                  [1:nCategories], index.category);
               
               for iCategory = 1:nCategories
                  theCategoryList = LocalSplice(insertPt,...
                     {param.pageList{theTopic}(iCategory).Name},...
                     theCategoryList);
                  insertPt = insertPt+1;
               end
               set(categoryListH, 'String', theCategoryList);
            else
               insertPt = insertPt + 1;
               while (index.topic(insertPt) == theTopic) 
                  index.topic(insertPt) = [];
                  index.category(insertPt) = [];
                  theCategoryList(insertPt) = [];                   
                  
                  if (insertPt > length(index.topic))
                     break;
                  end
               end
               set(categoryListH, 'String', theCategoryList);
            end
            set(categoryListH, 'UserData', index);
            set(categoryListH, 'ListboxTop', oldListboxTop)
         end   
         
         set(runBtn, 'String', 'Testuj', 'Enable', 'off');

        if (index.expanded(theTopic))
            helpMsg = chooseMsg;
         else
            helpMsg = clickMsg;
         end
         set(demoListH, 'String', helpMsg, ...
            'Max', 2, ...
            'Value', [], ...
            'Enable', 'inactive');
         set(aboutListH, 'String', aboutTopics{theTopic});
         set(aboutListH, 'Value', []);
         LocalSetPdfBtn(pdfBtn, theTopic);

      else % if (category ~= 0) i.e. we have chosen a category
         theCategoryName = param.pageList{theTopic}(theCategory).Name;
         demoLabel=[theCategoryName ' Demos']; 
         
         demoList=char(param.pageList{theTopic}(theCategory).DemoList);
         % set callback
         fcnList=char(param.pageList{theTopic}(theCategory).FcnList);

         theDemo = 1;
         demoFcn = fcnList(theDemo,:);
         
         set(demoListH, 'Enable', 'on', 'Max', 1, 'Value', 1);
         set(demoListH, 'String', demoList);
         LocalSetRunBtn(runBtn, demoList(1,:), demoFcn);
         LocalSetPdfBtn(pdfBtn, theTopic);

         % now set new text in the 'about' list
         % Help is a cell array of strings
         hlpStr=param.pageList{theTopic}(theCategory).Help;
         % Name is a string
         namestr=param.pageList{theTopic}(theCategory).Name;
         namestr(1:length(indent)) = [];  %strip pad
         
         % add a space
         if (theTopic == 1) % 
            spacestr = ' ';
         else
            spacestr = [];
         end
         % kludge: add some blanks to avoid colormap wierdness
         set(aboutListH, 'String', [{namestr}; {spacestr}; hlpStr; ...
               {' '}; {' '}]);
         set(aboutListH, 'Value', []);
      end % if (theCategory == 0), % this is a topic heading
      
      
   case 'showdemo',  % i.e. a click on the demo list
      
      theDemo = get(demoListH, 'Value');
      demoList=char(param.pageList{theTopic}(theCategory).DemoList);
      
      %set callback
      fcnList=char(param.pageList{theTopic}(theCategory).FcnList);
      demoFcn = fcnList(theDemo,:);
      
      LocalSetRunBtn(runBtn, demoList(theDemo,:), demoFcn); 
      LocalSetPdfBtn(pdfBtn, theTopic);
     
      if (strcmp(clickType,'open'))
         LocalRunDemo(runBtn);
      end
      
   end % switch
   
   
   %=====================================
   % Handle INITIALIZATION
elseif strcmp(action,'initialize'),
   
   % POSITION AND CREATE FIGURE

   figureColor=[0.648 0.777 0.894];
   %figurePos=[30 15 90 35];
   figurePos=[20 10 130 45];
   
   figH=figure( ...
      'Name', 'Úvod do Matematických Výpočtů', ...
      'Units', 'characters', ...
      'NumberTitle','off', ...
      'Visible','off', ...
      'IntegerHandle','off', ...
      'Resize','on', ...
      'Color', figureColor, ...
      'Position',figurePos, ...
      'Pointer','watch', ...
      'MenuBar','none', ... 
      'Tag', 'umv');

   % banner graphic
%    oldRootUnits = get(0,'Units');
%    set(0, 'Units', 'points');
%    pixfactor = 72/get(0,'screenpixelsperinch')
%    set(0, 'Units', oldRootUnits);

   banner=imread('nastaveni/banner_UMV.jpg');
   oldUnits = get(figH,'Units');  
   set(figH, 'Units', 'points');
   Fig_Pos=get(figH,'Position');
   set(figH, 'Units', oldUnits);

   set(gca,'Units','points');
%   Ban_Pos=get(gca, 'Position')
   koefx=5;
   koefy=83.5;
   Ban_Pos(1)=koefx/100*Fig_Pos(3);
   Ban_Pos(2)=koefy/100*Fig_Pos(4);
   Ban_Pos(3)=(100-2*koefx)/100*Fig_Pos(3);
   Ban_Pos(4)=(100-koefy-koefx)/100*Fig_Pos(4);
   set(gca, 'Position', Ban_Pos);
   set(gca,'Units','normal');
   bannerH = image(banner);
   axis off;
   autor=text(30,327,[datum,'     Josef Daněk']);
%   set(autor,'FontWeight','bold');
 %  set(autor,'Color',[0.35 0.41 0.5]);
   set(autor,'Color',[0.386 0.275 0.058],'FontWeight','bold');


   % Initialize  buttons and listboxes
   boxesNButtons = Localbuildpage(figH, chooseMsg);
   
   % when this precedes the Localbuildpage invocation,
   % the rest of the graphic disappears on UNIX (not PC)
   % make the figure visible
   set(figH, 'Visible', 'on','Pointer','watch');
   
   drawnow;
   % watchon here:
   % otherwise, watchon before drawnow puts up an I beam
   % with it around here, it's an arrow. ' 
   
   % INITIALIZE CONTENT STRUCTURES
   
   cd(pomocny_adresar);
   p1List = pr1_info;
   p2List = pr2_info;
   p3List = pr3_info;
   p4List = pr4_info;
   p5List = pr5_info;
   p6List = pr6_info;
   p7List = pr7_info;
   p8List = pr8_info;
   p9List = pr9_info;
   p10List = pr10_info;
   p11List = pr11_info;
   p12List = pr12_info;
   cd ..;
   
   nTopics=1;
   topicList{1}='1. přednáška';
   pageList{1} = p1List;
   
   if ~isempty('p2List')
      nTopics=nTopics+1;       
      topicList{nTopics}='2. přednáška';
      pageList{nTopics} = p2List;
   end

   if ~isempty('p3List')
      nTopics=nTopics+1;       
      topicList{nTopics}='3. přednáška';
      pageList{nTopics} = p3List;
   end

   if ~isempty('p4List')
      nTopics=nTopics+1;       
      topicList{nTopics}='4. přednáška';
      pageList{nTopics} = p4List;
   end

   if ~isempty('p5List')
      nTopics=nTopics+1;       
      topicList{nTopics}='5. přednáška';
      pageList{nTopics} = p5List;
   end

   if ~isempty('p6List')
      nTopics=nTopics+1;       
      topicList{nTopics}='6. přednáška';
      pageList{nTopics} = p6List;
   end

   if ~isempty('p7List')
      nTopics=nTopics+1;       
      topicList{nTopics}='7. přednáška';
      pageList{nTopics} = p7List;
   end

   if ~isempty('p8List')
      nTopics=nTopics+1;       
      topicList{nTopics}='8. přednáška';
      pageList{nTopics} = p8List;
   end

   if ~isempty('p9List')
      nTopics=nTopics+1;       
      topicList{nTopics}='9. přednáška';
      pageList{nTopics} = p9List;
   end

   if ~isempty('p10List')
      nTopics=nTopics+1;       
      topicList{nTopics}='10. přednáška';
      pageList{nTopics} = p10List;
   end

  if ~isempty('p11List')
      nTopics=nTopics+1;       
      topicList{nTopics}='11. přednáška';
      pageList{nTopics} = p11List;
   end

   if ~isempty('p12List')
      nTopics=nTopics+1;       
      topicList{nTopics}='Písemná práce';
      pageList{nTopics} = p12List;
   end

   param.pageList  = pageList;
   param.topicList = topicList;  
   
   for iTopic = 1:nTopics
      nCategories = length({param.pageList{iTopic}.Name});
      topicList{iTopic} = ['+' topicList{iTopic}];
      for iCategory = 1:nCategories
         param.pageList{iTopic}(iCategory).Name ...
            = [indent param.pageList{iTopic}(iCategory).Name];
      end
   end
   
   % save this global data into the figure info
   set(figH,'UserData',param);
   
   categoryListH = findobj(figH, ...
      'Type', 'uicontrol', 'Tag', 'CategoryListbox');
   
   % make an index for the entries visible in the category list box    
   index.topic = [1:nTopics];
   index.category = zeros(1,nTopics);
   index.expanded = zeros(1,nTopics);

   set(categoryListH, ...
      'UserData', index, ...
      'String', topicList, ...
      'Value', 1);
   
   % allow resizing
   set(boxesNButtons, 'Units', 'normalized');
   
   % Initialization is now complete.
%   set(waitH, 'Visible', 'off');

   set(boxesNButtons, 'Visible', 'on');
   drawnow;
   refresh;
   set(figH,'Pointer','arrow');


elseif strcmp('pdfview',action)
   if exist('figH')
      Localview(findobj(figH,'Type', 'uicontrol', 'Tag', 'pdf'))
   end;
end;  %

%====================================
function handleArray = Localbuildpage(figH, chooseMsg)
%  build buttons and listboxes for each page

figureColor = get(figH, 'Color');

%====================================
% pull out the geometry information

aboutListPos = [52.5 24 72 10.4];
demoListPos = [52.5 5.5 72 17];
catListPos =[5 5.5 44 29];
closeBtnPos = [18.5  1.5  16.5000 2.2500] ;
runBtnPos = [96 1.5  16.5000 2.2500] ;
pdfBtnPos = [65 1.5 16.5000 2.2500] ;
% aboutListPos = [35 16.5 50 10];
% demoListPos = [35 5.5 50 10];
% catListPos =[5 5.5 27 21.2];
% closeBtnPos = [10  1.5  16.5000 2.2500] ;
% runBtnPos = [63 1.5  16.5000 2.2500] ;
% pdfBtnPos = [41 1.5 16.5000 2.2500] ;


% build demo listbox
demoListH = uicontrol( ...
   'Style', 'list', ...
   'HorizontalAlignment','left', ...
   'Units', 'character', ...
   'Visible', 'off',...
   'BackgroundColor', [0.845 0.855 0.865], ...
   'ForegroundColor', [0.286 0.330 0.340], ...
   'Max', 2, ...
   'Value', [], ...
   'Enable', 'inactive', ...
   'Position', demoListPos, ...
   'Callback', 'umv showdemo', ...
   'String', chooseMsg, ...
   'Tag', 'DemoListbox', ...
   'FontSize',12);

% Set up category listbox
tbxListH = uicontrol( ...
   'Style', 'list', ...
   'HorizontalAlignment','left', ...
   'Units','character', ...
   'Visible','off',...
   'BackgroundColor', [0.845 0.855 0.865], ...
   'ForegroundColor', [0.286 0.330 0.340], ...
   'Max', 1, ...
   'Value', 1, ...
   'Enable', 'on', ...
   'Position', catListPos, ...
   'Callback', 'umv showlist', ...
   'String', ' ', ...
   'Tag', 'CategoryListbox', ...
   'FontSize',12);

uvodni_rec={ ...
    ' Právě jste spustili výukový program umv.m,'
    ' který slouží ke spouštění demonstračních  '
    ' příkladů připravených k výkladu předmětu  '
    '                                           '
    '       Úvod do matematických výpočtů.      '
    '                                           '
    ' Nejprve si zvolte přednášku v levém menu. '
    ' Dvojím kliknutím ji rozbalíte nebo sbalíte.'
    ' Dále si zvolte téma, které Vás zajímá.    '
    ' Pro zvolené téma se v pravém dolním menu  '
    ' zobrazí seznam demo příkladů, které lze   '
    ' spustit dvojím kliknutim.                 '
    '                                           '
    ' Ke každé přednášce je k dispozici         '
    ' doprovodný text v PDF formátu, který lze  '
    ' zobrazit použitím tlačítka "Zobraz PDF".  '
    '                                           '
    ' ------------------------------------------'
    ' Autor :    Josef Daněk                    '
    ' ------------------------------------------'
    '                                           '
    };

% create a listbox for displaying the 'about' information
aboutListH = uicontrol( ...
   'Style', 'list', ...
   'HorizontalAlignment','left', ...
   'Units','character', ...
   'Visible','off',...
   'BackgroundColor', figureColor, ...
   'Min', 0, ...
   'Max', 2, ...
   'Value', [], ...
   'Enable', 'on', ...
   'Position', aboutListPos, ...
   'Callback', '', ...
   'String', uvodni_rec, ...
   'Tag', 'AboutListbox', ...
   'UserData', LocalLoadTopics, ...
   'FontSize',12);


% The close button
backH = uicontrol( ...
   'Style', 'pushbutton', ...
   'Units', 'character', ...
   'Position', closeBtnPos, ...
   'BackgroundColor', [0.445 0.516 0.555], ...
   'String', 'KONEC', ...
   'Visible', 'off', ...
   'Tag', 'return', ...
   'Callback', 'close(gcbf)', ...
   'FontSize',12); 

% The run button    
runH = uicontrol( ...
   'Style', 'pushbutton', ...
   'Units', 'characters', ...
   'Position', runBtnPos, ...
   'BackgroundColor', [0.477 0.633 0.715], ...
   'String', 'Testuj', ...
   'Visible', 'off', ...
   'Enable', 'off', ...
   'Tag', 'test', ...
   'Callback', 'umv rundemo', ...
   'FontSize',12); 

% The pdf button    
pdfH = uicontrol( ...
   'Style', 'pushbutton', ...
   'Units', 'characters', ...
   'Position', pdfBtnPos, ...
   'BackgroundColor', [0.477 0.633 0.715], ...
   'String', 'Zobraz PDF', ...
   'Visible', 'on', ...
   'Enable', 'off', ...   
   'Tag', 'pdf', ...
   'Callback', 'umv pdfview', ...
   'FontSize',12); 

handleArray = [runH pdfH backH aboutListH tbxListH demoListH];


% =====================================
function aboutTopicArray = LocalLoadTopics

about1 = {...
   ' Do jaké míry lze věřit výsledkům, které      ' 
   ' získáme výpočtem na kalkulačce či počítači ? '
   '                                              ' 
   ' Na několika příkladech naznačíme úskalí,     '
   ' která mohou vést k tomu, že je výsledek      ' 
   ' výpočtu nepřesný nebo zcela špatný.          '
   };
about2 = {...
   ' Ukážeme různé chyby v matematických výpočtech'
   ' a jejich souvislost s podmíněností úlohy.    ' 
   '                                              '
   ' Pro pochopení principu zobrazování čísel     ' 
   ' v počítači si připomeneme různé číselné      ' 
   ' soustavy a ukážeme si několik příkladů na    '
   ' převod z jedné soustavy do druhé.            '
    };

about3 = {...
   ' Vysvětlíme si princip, jak jsou v počítači   '
   ' uložená čísla v normalizované pohyblivé      '
   ' řádové čárce (REAL).                         '
   ' Na jednoduchých příkladech ukážeme jaké      '
   ' chyby vzniknou při sčítání strojových čísel  '
   ' vlivem nepřesného uložení čísel v počítači.  '   
   };

about4 = {...
   ' Celá řada metod je založena na iteračním     '
   ' principu. Po zadání počáteční aproximace     ' 
   ' řešení se v každé iteraci snažíme výsledek   '
   ' zpřesnit. Pro ukončení iteračního procesu    '
   ' je dále nutné zvolit nějakou zastavovací     '  
   ' podmínku, např. počet iterací.               '
   };

about5 = {...
   ' Základním principem, na kterém je založena   '
   ' celá řada metod je metoda prosté iterace.    '
   ' Budeme zkoumat, za jakých podmínek metoda    '
   ' konverguje, jaká je chyba přibližného řešení '
   ' a jaká je rychlost konvergence metody.       ' 
   };

about6 = {...
   ' Na jednoduchém dynamickém modelu (popsaného  '
   ' diferenční rovnicí) si ukážeme jak moc může  '
   ' být výsledek závislý (citlivý) na parametrech'
   ' použitých v modelu. Ukážeme si případy, ve   ' 
   ' kterých použitý parametr vede ke zdánlivě    '
   ' nepředvídatelnému chování celého systému, tzv.'
   ' deterministickému chaosu.                    '
    };

about7 = {...
    ' Na jednoduchých příkladech si ukážeme dva   '
    ' způsoby měření délky pobřeží. První způsob  '
    ' využívá čtvercovou síť a druhý využívá      '
    ' kružítka. U obou způsobů je zajímavý fakt,  '
    ' že se zmenšujícím se měřidlem se délka      '
    ' pobřeží zvětšuje.' 
    '                                             '
    ' Dále si ukážeme jeden ze způsobů konstrukce '
    ' fraktálových struktur. Vykreslíme několik   ' 
    ' případů tzv. Juliovy množiny a také tzv.    '
    ' Mandelbrotovu množinu.                      ' 
    };

about8 = {...
   ' Jednou z nejčastějších činností je předávání '
   ' zpráv. Díky okolním vlivům však může dojít   '
   ' při přenosu dat k chybě. Pokud chceme elimi- ' 
   ' novat vzniklé chyby, je vhodné použít tzv.   '
   ' samoopravný kód, kteýy dokáže některé chyby  '
   ' sám opravit.                                 '
   ' Podobný princip se využívá například při     '
   ' konstrukci rodného čísla nebo kódu ISBN pou- '
   ' žívaného k jednoznačné identifikaci knih.    '
    };

about9 = {...
   ' Pro bezpečné posílání zpráv se používá       '
   ' šifrování. V dřívějších dobách se k šifrování'
   ' používal tajný klíč, který ovšem musely znát '
   ' všechny komunikující strany a snadno mohlo   '
   ' dojít k jeho prozrazení. Ukážeme si metodu   '
   ' RSA, která se používá pro bezpečné šifrování '
   ' pomocí veřejného klíče.                      '
    };

about10 = {...
   ' Na úvod si připomeneme logický paradox, ve   ' 
   ' kterém nemůže Achilles dohonit želvu. Dále   '
   ' na jednoduchém příkladu vykreslování grafu   '
   ' funkce si ukážeme souvislosti mezi spojitým  '
   ' a diskretním chápáním přírody. Spojitá       '
   ' funkce na libovolném intervalu je definována '
   ' v nekonečně mnoha bodech, tj. nelze ji obecně'
   ' přesně vykreslit a musíme použít metody      '
   ' aproximace funkce. '
    };

about11 = {...
   ' Výpočet derivace funkce v bodě a výpočet     '
   ' hodnoty určitého integrálu lze přehledně     '
   ' geometricky interpretovat. Obě úlohy mají    '
   ' ovšem jiné vlastnosti. Zatímco při derivování'
   ' limitně zmenšujeme krok k nule, při integro- '
   ' vání limitně zvětšujeme počet kroků dělení   '
   ' k nekonečnu.                                 '
    };

about12 = {...
   ' Pro ověření znalostí z předmětu              ' 
   '                                              '
   '      Úvod do matematických výpočtů           '
   '                                              '
   ' si můžete vyzkoušet spočítat vzorové zadání  '
   ' písemné práce.                               '
   '                           Přeji mnoho zdaru! '
    };

aboutTopicArray = {about1 about2 about3 about4 about5 ...
                   about6 about7 about8 about9 about10 ... 
                   about11 about12};

%=====================================
% insert into string, array or cell array of dim 1xn or nx1
function together = LocalSplice(insertPt, piece, target)

[sizeOne sizeTwo] = size(target);
% splice along the big dimension
if sizeOne > 1
   dim = 1;
   nItems = sizeOne;
   if sizeTwo > 1
      % then this is ambiguous...
   end
else % sizeTwo > 1
   dim = 2;
   nItems = sizeTwo;
end

if (insertPt<1)
   together =  cat(dim, piece, target);
elseif (insertPt>nItems)
   together =  cat(dim, target, piece);
else
   together = cat(dim, target(1:insertPt), ...
      piece,...
      target(insertPt+1:nItems));
end

% =====================================
function theTopic = LocalGetTopic(topicList, targetString, noHitTopic)

hits = strmatch(targetString, topicList);
if (hits)
   theTopic = hits(1);
else
   theTopic = noHitTopic;  % default if we don't find it
end

% =====================================
function LocalSetRunBtn(runBtn, labelStr, demoFcn)

nMax = 8;

if isempty(labelStr)
    labelStr='';
else
  % remove trailing and leading blanks
  [r,c] = find(labelStr ~= ' ' & labelStr ~= 0);
  if isempty(c)
    labelStr = '';
  else
    labelStr = labelStr(:,min(c):max(c));
  end
end

demoData.demoFcn = deblank(demoFcn);
demoData.demoName = labelStr;

% first, clip
if (length(labelStr)>nMax)
   labelStr = labelStr(1:nMax);

   % find the last space before the nMax'th character
   spaces = findstr(' ', labelStr);

   if (isempty(spaces))
      labelStr = [labelStr '...'];
   else
      % truncate to last complete word before nMax
      lastSpace = spaces(length(spaces));
      labelStr = [labelStr(1:lastSpace) '...'];
   end
end
if isempty(demoData.demoFcn)
   runString='Testuj';
   btnEnable='off';
else
   runString=['Testuj ' labelStr];
   btnEnable='on';
end

set(runBtn, ...
   'String', runString , ...
   'Enable',btnEnable, ...
   'UserData', demoData);

% =====================================
function warningStr = LocalSetWarningStr(demoFcn, demoName)
warningStr = ...
   ['Error running "' demoName '" demo (' ...
         demoFcn '):' ];

% =====================================
% protect against demos clearing the workspace
function errorStatus = LocalSafeEval(tryStr, warningStr)

   % allow single quotes in the name of the demo
   warningStr = LocalDoubleQuote(warningStr);
   catchStr = ...
       ['errordlg([''' warningStr ''' sprintf(''\n'') lasterr],'...
          '''Demo Error'', ''replace''); errorCaught=1;'];
   errorStatus = LocalOneLevelDeeper(tryStr, catchStr);

% =====================================
function errorCaught = LocalOneLevelDeeper(tryStr, catchStr)
   errorCaught = 0;
   evalin('caller',tryStr, catchStr);
   % errorStatus bound in catchStr if there is an error

% =====================================
% view PDF file
function Localview(pdfBtn)

if exist('pdfBtn')
  adresar_umv=cd;
  clc;
  cd('pdf_soubory');
  out=is_acroread;
  if (out==1)|(out==2)|(out==4)
    pdfData = get(pdfBtn,'UserData');
    switch pdfData
      case 1,
        soubor='umv_prednaska_01.pdf';
      case 2,
        soubor='umv_prednaska_02.pdf';
      case 3,
        soubor='umv_prednaska_03.pdf';
      case 4,
        soubor='umv_prednaska_04.pdf';
      case 5,
        soubor='umv_prednaska_05.pdf';
      case 6,
        soubor='umv_prednaska_06.pdf';
      case 7,
        soubor='umv_prednaska_07.pdf';
      case 8,
        soubor='umv_prednaska_08.pdf';
      case 9,
        soubor='umv_prednaska_09.pdf';
      case 10,
        soubor='umv_prednaska_10.pdf';
      case 11,
        soubor='umv_prednaska_11.pdf';
      case 12,
        soubor='pisemka_umv_vzor.pdf';
    end;
    disp(' ');
    disp(sprintf(' Zobrazuji soubor:   %s',soubor));
    disp(' ');
  end;
  if out==1
    switch pdfData
      case 1,
        unix 'acroread umv_prednaska_01.pdf&';
      case 2,
        unix 'acroread umv_prednaska_02.pdf &';
      case 3,
        unix 'acroread umv_prednaska_03.pdf &';
      case 4,
        unix 'acroread umv_prednaska_04.pdf &';
      case 5,
        unix 'acroread umv_prednaska_05.pdf &';
      case 6,
        unix 'acroread umv_prednaska_06.pdf &';
      case 7,
        unix 'acroread umv_prednaska_07.pdf &';
      case 8,
        unix 'acroread umv_prednaska_08.pdf &';
      case 9,
        unix 'acroread umv_prednaska_09.pdf &';
      case 10,
        unix 'acroread umv_prednaska_10.pdf &';
      case 11,
        unix 'acroread umv_prednaska_11.pdf &';
      case 12,
        unix 'acroread pisemka_umv_vzor.pdf &';
    end;
  end;
  if out==2
    switch pdfData
      case 1,
        unix 'xpdf umv_prednaska_01.pdf&';
      case 2,
        unix 'xpdf umv_prednaska_02.pdf &';
      case 3,
        unix 'xpdf umv_prednaska_03.pdf &';
      case 4,
        unix 'xpdf umv_prednaska_04.pdf &';
      case 5,
        unix 'xpdf umv_prednaska_05.pdf &';
      case 6,
        unix 'xpdf umv_prednaska_06.pdf &';
      case 7, 
        unix 'xpdf umv_prednaska_07.pdf &';
      case 8,
        unix 'xpdf umv_prednaska_08.pdf &';
      case 9,
        unix 'xpdf umv_prednaska_09.pdf &';
      case 10,
        unix 'xpdf umv_prednaska_10.pdf &';
      case 11,
        unix 'xpdf umv_prednaska_11.pdf &';
      case 12,
        unix 'xpdf pisemka_umv_vzor.pdf &';
     end;
  end;
  if out==3
    disp('Nemohu zobrazit PDF soubory ... Není k dispozici Acroread ani Xpdf');
  end;
  if out==4
    dos(sprintf('Reader\\Reader\\AcroRd32 %s &',soubor));
  end;
  cd(adresar_umv);
end

% =====================================
% run from the run button or from double click
function LocalRunDemo(runBtn)

grt=get(runBtn,'Tag')
if grt=='test'
    
%if exist(runBtn)
   adresar_umv=cd;
   figH = gcbf;
   demoData = get(runBtn,'UserData');

   %======================================
   % Check for product dependencies and make sure all products
   % are present.  Only start demo if all is OK.  Else, show
   % an error dialog.

   dn=demoData.demoName;      

   % only check if there are parens in the demo name
   if ~isempty(dn) & sum(dn=='(')
      % pull out whatever is between the parens
      depends=dn(find(dn=='(')+1:find(dn==')')-1);
      % cut out any spaces
      depends(find(depends==' '))='';
      prodList={};
      depends=[',' depends];
      csMarker=cumsum(depends==',');
      % loop over the number of commas
      for i=1:csMarker(end);
         nextOne=depends(csMarker==i);
         % chop off comma
         nextOne(1)='';
         % stuff string into cell array
         prodList{1,i}=nextOne;
      end;
   end;
   ProductMissing='';

   % End of product checking code.
   %======================================


   % If there's a product missing, pop up the dialogue...
   if ~isempty(ProductMissing)
      ContactUs='Contact The MathWorks for more information.';
      msgbox({ProductMissing;ContactUs},'Product Missing','modal')

      % else fire off the demo.
   else
      set(figH,'Pointer','watch');  % watchon
      oldFigs = allchild(0)';       % work with row vectors

      warningStr = LocalSetWarningStr(demoData.demoFcn, ...
         demoData.demoName);
      lasterr('');
      errorCaughtInDemo = LocalSafeEval(demoData.demoFcn, warningStr);

      set(figH,'Pointer','arrow');  % watchoff

      % flush the HG event queue so we get the right stacking order
      drawnow;

      currentFigs = allchild(0)';
      currentVisFigs = currentFigs(find(LocalIsVisible(currentFigs)));

      if errorCaughtInDemo
         % then close all new windows (including invisible figures
         % and systems) except the error dialog

         % we have used errordlg with Replace='replace', so there should not
         % ever be more than one errorfig with this name
         errorFig = findobj(currentFigs,'Name', 'Demo Error');

         % some of the figures (scopes) may already be closed
         currentFigs = allchild(0)';
         close(setdiff(setdiff(currentFigs,oldFigs),[errorFig]));
         % bring error dialog to front
         figure(errorFig);
         lasterr('');
      else
         % bring new windows to front;
         % setdiff sorts its result:
         % so use ismember to preserve ordering of new figs

         newVisFigs = ...
            currentVisFigs(find(~ismember(currentVisFigs,oldFigs)));
                 for f = fliplr(newVisFigs)
                        % f may contain Java frames in addition to figure.
                        % Make sure f is a figure
                        if strcmp(get(f,'Type'),'figure'),
                           figure(f);
                        end
                 end
          end
   end
  cd(adresar_umv);
end

% =====================================
function resultV = LocalIsVisible(aFigHandleVector)
resultV = strcmp('on', get(aFigHandleVector,'Visible'))'; %'
% returns a row vector


% =====================================
function lowerArray = LocalCellLower(theCellArray)

   i = 1;
   for anElement = theCellArray
      lowerArray{i} = lower(anElement{1});
      i = i+1;
   end

%==================================================
function outStr=LocalDoubleQuote(inStr)
% add double quote to quoted string
    outStr=inStr(sort([1:length(inStr) find(inStr=='''')]));



%==================================================
function LocalSetPdfBtn(pdfBtn,theTopic)
set(pdfBtn, 'UserData', theTopic);
set(pdfBtn, 'Enable', 'on');














