%   Priklad z knihy N. Highama, Accuracy and stability of Numerical
%   Algorithms, SIAM, 2002, str. 9
%
%   zajima nas vyhodnoceni funkce (1 - cos x) / x^2
%
x = 1.2e-8;
c = cos(x);

fprintf('x = %20.16e \n',x);
fprintf('cos(x) = %20.16e (.999999999999999928)\n',c);
fprintf('1-cos(x) = %20.16e (.7200000000000000e-16)\n',1-c);
fprintf('(1-cos(x))/x^2 = %20.16e \n',(1-c)/x^2);

%
%   vysledek je spocten nepresne. V citeli dochazi k odecteni 
%   dvou blizkych cisel a vysledek neni spravne na jedinou 
%   platnou cislici. Pote je "zesilen" pomoci x^-2 a chyba
%   se vyrazne projevi
%

%
%   vyuzijeme-li toho, ze cos(x) = 1 - 2 (sin(x/2))^2,
%   lze f(x) vyhodnotit numericky stabilne.
%
y = x/2;
f = 0.5*(sin(y)/y)^2;


fprintf('0.5*(sin(x/2)/(x/2))^2 = %20.16e \n',f);


