function [Q,R] = cgs(A,iter);

if nargin == 1, iter = 1; end;

[m,n] = size(A);
s = min(m,n);

Q = zeros(m,s);
r = zeros(s,n);
R = zeros(s,n);

for i = 1:n,
    z = A(:,i);
    for k = 1:iter,
        for j = 1:min(m,i-1),
            r(j,i) = Q(:,j)'*z;
        end;
        for j = 1:min(m,i-1),
            z = z - Q(:,j) * r(j,i);
            R(j,i) = R(j,i) + r(j,i);
        end;
    end;
    if i<=m,
        R(i,i) = norm(z);
        Q(:,i) = z/R(i,i);
    end;
end;