%
% example 4: Krylov matrix - special
%
clear;
fprintf('A = Krylov matrix: K_j = (x,Bx,B^2x,...,B^(j-1)x) \n');
fprintf('B = special matrix 200 x 200\n');
fprintf('A = Krylov matrix 200 x 10\n\n');
n = 200;

B = zeros(n,n);
for i = 1:n,
    for j = 1:i,
        B(i,j) = n-i+1;
    end;
    if i<n,
        B(i,i+1) = n-i;
    end;    
end;

x=ones(200,1);

A = gallery('krylov',B,x,10);
fprintf('|A|_2 = %e\n',norm(A));
fprintf('cond(A) = %e\n',cond(A));

r = rank(A);
fprintf('rank(K_10) = %g\n',r);
